<?php

// Function to get all products
function get_all_products($conn) {
    $stmt = $conn->prepare("SELECT p.prod_id, p.prod_name, p.prod_price, p.prod_desc, v.vend_name
                             FROM crashcourse.products p
                             JOIN crashcourse.vendors v ON p.vend_id = v.vend_id
                             ORDER BY p.prod_id");
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Function to get a product by its ID (prod_id)
function get_product_by_id($conn, $prod_id) {
    $stmt = $conn->prepare("SELECT p.prod_id, p.prod_name, p.prod_price, p.prod_desc, v.vend_name
                             FROM crashcourse.products p
                             JOIN crashcourse.vendors v ON p.vend_id = v.vend_id
                             WHERE p.prod_id = :prod_id");  // Treat prod_id as a string
    $stmt->bindParam(':prod_id', $prod_id, PDO::PARAM_STR);  // Use PDO::PARAM_STR to bind the prod_id as a string
    $stmt->execute();
    return $stmt->fetch(PDO::FETCH_ASSOC);  // Fetch a single product
}


// Function to update a product
function update_product($conn, $prod_id, $prod_name, $prod_price, $prod_desc, $vend_id) {
    $stmt = $conn->prepare("UPDATE products SET 
                            prod_name = :prod_name, 
                            prod_price = :prod_price, 
                            prod_desc = :prod_desc, 
                            vend_id = :vend_id
                            WHERE prod_id = :prod_id");
    $stmt->bindParam(':prod_id', $prod_id);
    $stmt->bindParam(':prod_name', $prod_name);
    $stmt->bindParam(':prod_price', $prod_price);
    $stmt->bindParam(':prod_desc', $prod_desc);
    $stmt->bindParam(':vend_id', $vend_id);
    $stmt->execute();
    header("Location: product_details.php?product_id=" . $prod_id);
    exit();
}

// Function to add a new product
function add_product($conn, $prod_id, $prod_name, $prod_price, $prod_desc, $vend_id) {
    $stmt = $conn->prepare("INSERT INTO products (prod_id, prod_name, prod_price, prod_desc, vend_id)
                            VALUES (:prod_id, :prod_name, :prod_price, :prod_desc, :vend_id)");

    $stmt->bindParam(':prod_id', $prod_id);
    $stmt->bindParam(':prod_name', $prod_name);
    $stmt->bindParam(':prod_price', $prod_price);
    $stmt->bindParam(':prod_desc', $prod_desc);
    $stmt->bindParam(':vend_id', $vend_id);
    $stmt->execute();

    header("Location: product_details.php?product_id=" . $prod_id);
    exit();
}

// Function to check if a product exists by its ID (prod_id)
function product_exists($conn, $prod_id) {
    $stmt = $conn->prepare("SELECT COUNT(*) FROM products WHERE prod_id = :prod_id");
    $stmt->bindParam(':prod_id', $prod_id);
    $stmt->execute();
    return $stmt->fetchColumn() > 0;
}

?>
